<?php

namespace App\Modules\Finance\Migrations\TreasuryTransfer;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TreasuryTransfer extends Model 
{

    protected $table = 'treasury_transfers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function sourceTreasury()
    {
        return $this->belongsTo('Treasury', 'source_treasury_id');
    }

    public function destinationTreasury()
    {
        return $this->belongsTo('Treasury', 'destination_treasury_id');
    }

    public function bank()
    {
        return $this->belongsTo('CustomerBankAccount', 'bank_id');
    }

}